#include "SDL.h"
#include "SDL_ttf.h"

#define DISPLAY_WIDTH 320
#define DISPLAY_HEIGHT 240
#define DISPLAY_BPP 16

#ifdef USE_JAPANESE_FONT
#define FONT_FILE "japanese.ttf"
#else /* USE_JAPANESE_FONT */
#define FONT_FILE "/usr/share/fonts/truetype/dejavu/DejaVuSans.ttf"
#endif /* USE_JAPANESE_FONT */

#define FONT_SIZE 30

#ifdef USE_JAPANESE_FONT
#define HELLO_WORLD "ようこそ GCW Zero へ"
#else /* USE_JAPANESE_FONT */
#define HELLO_WORLD "--- Hello World ---"
#endif /* USE_JAPANESE_FONT */

int main(int ac, char **av)
{
  SDL_Color white = {0xff, 0xff, 0xff};
  SDL_Event event;
  SDL_Rect string_rect, display_rect;
  SDL_Surface* display;
  SDL_Surface* string_image;
  TTF_Font* font;
  int e_loop = 1;

  if(SDL_Init(SDL_INIT_VIDEO) < 0){
    exit(1);
  }

  SDL_ShowCursor(SDL_DISABLE);

  display = SDL_SetVideoMode(DISPLAY_WIDTH, DISPLAY_HEIGHT, DISPLAY_BPP,
                             SDL_SWSURFACE | SDL_DOUBLEBUF);
  if(display == NULL){
    SDL_Quit();
    exit(2);
  }

  if(TTF_Init() != 0){
    SDL_Quit();
    exit(3);
  }

  font = TTF_OpenFont(FONT_FILE, FONT_SIZE);
  if(font == NULL){
    SDL_Quit();
    exit(4);
  }

  string_image = TTF_RenderUTF8_Blended(font, HELLO_WORLD, white);
  if(string_image == NULL){
    TTF_CloseFont(font);
    TTF_Quit();
    SDL_Quit();
    exit(5);
  }

  string_rect.x = 0;
  string_rect.y = 0;
  string_rect.w = string_image->w;
  string_rect.h = string_image->h;

  display_rect.x = (DISPLAY_WIDTH - string_rect.w) / 2;
  display_rect.y = (DISPLAY_HEIGHT - string_rect.h) / 2;

  if(SDL_BlitSurface(string_image, &string_rect, display, &display_rect) != 0){
    SDL_FreeSurface(string_image);
    TTF_CloseFont(font);
    TTF_Quit();
    SDL_Quit();
    exit(6);
  }

  if(SDL_Flip(display) != 0){
    SDL_FreeSurface(string_image);
    TTF_CloseFont(font);
    TTF_Quit();
    SDL_Quit();
    exit(7);
  }

  while(e_loop){
    if(SDL_PollEvent(&event)){
      switch(event.type){
      case SDL_KEYDOWN:
        e_loop = 0;
        break;
      default:
        SDL_Delay(1);
        break;
      }
    }else{
      SDL_Delay(1);
    }
  }
 
  SDL_FreeSurface(string_image);
  TTF_CloseFont(font);
  TTF_Quit();
  SDL_Quit();

  return 0;
}
