/* eglinfo.c version 0.2 */

#include <stdio.h>
#include <stdlib.h>
#include <EGL/egl.h>
#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#include <X11/Xlib.h>

void closeWindow(void);
void splitExtensions(const char *str);

Display       *xDisplay = NULL;
Window        xWindow = 0;
EGLDisplay    eglDisplay = EGL_NO_DISPLAY;
EGLContext    eglContext = EGL_NO_CONTEXT;
EGLSurface    eglSurface = EGL_NO_SURFACE;

void closeWindow(void)
{
  if(eglDisplay != EGL_NO_DISPLAY){
    eglMakeCurrent(eglDisplay, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
    if(eglContext != EGL_NO_CONTEXT){
       eglDestroyContext(eglDisplay, eglContext);
    }
    if(eglSurface != EGL_NO_SURFACE){
       eglDestroySurface(eglDisplay, eglSurface);
    }
    eglTerminate(eglDisplay);
    eglDisplay = EGL_NO_DISPLAY;
    eglContext = EGL_NO_CONTEXT;
    eglSurface = EGL_NO_SURFACE;
  }

  if(xDisplay != NULL){
    if(xWindow != 0){
      XDestroyWindow(xDisplay, xWindow);
      xWindow = 0;
    }

    XCloseDisplay(xDisplay);
    xDisplay = NULL;
  }

  return;
}

void splitExtensions(const char *str)
{
  const char *p;

  printf("\t");

  for(p = str ; *p != '\0' ; p++){
    if(*p == ' '){
      printf("\n\t");
    }else{
      printf("%c", *p);
    }
  }

  printf("\n");

  return;
}

int main(int ac, char **av)
{
  EGLConfig     eglConfig;
  EGLint        majorVersion, minorVersion, num_config;
  const char    *str;

  xDisplay = XOpenDisplay(NULL);
  if(xDisplay == NULL){
    printf("XOpenDisplay: Open Display Error\n");
    exit(1);
  }

  eglDisplay = eglGetDisplay((EGLNativeDisplayType)xDisplay);
  if(eglDisplay == EGL_NO_DISPLAY){
    printf("eglGetDisplay: Get Display Error\n");
    closeWindow();
    exit(2);
  }

  if(!eglInitialize(eglDisplay, &majorVersion, &minorVersion)){
    printf("eglInitialize: Initialize Error\n");
    closeWindow();
    exit(3);
  }
  //printf("eglInitialize: %d.%d\n", majorVersion, minorVersion);

  str = eglQueryString(eglDisplay, EGL_VERSION);
  if(str != NULL){
    printf("EGL_VERSION: %s\n", str);
  }

  str = eglQueryString(eglDisplay, EGL_VENDOR);
  if(str != NULL){
    printf("EGL_VENDOR: %s\n", str);
  }

  str = eglQueryString(eglDisplay, EGL_EXTENSIONS);
  if(str != NULL){
    printf("EGL_EXTENSIONS:\n");
    splitExtensions(str);
  }

  eglBindAPI(EGL_OPENGL_ES_API);

  static EGLint attribute_list[] = {
    EGL_RENDERABLE_TYPE, EGL_OPENGL_ES2_BIT,
    EGL_NONE
  };

  num_config = 0;
  eglChooseConfig(eglDisplay, attribute_list, &eglConfig, 1, &num_config);
  if(num_config == 0){
    printf("eglChooseConfig: Choose Config Error\n");
    closeWindow();
    exit(4);
  }

  static EGLint context_attribute_list[] = {
    EGL_CONTEXT_CLIENT_VERSION, 2,
    EGL_NONE
  };

  eglContext = eglCreateContext(eglDisplay, eglConfig, EGL_NO_CONTEXT,
                                context_attribute_list);
  if(eglContext == EGL_NO_CONTEXT){
    printf("eglCreateContext: Create Context Error\n");
    closeWindow();
    exit(5);
  }

  xWindow = XCreateSimpleWindow(xDisplay,
                                RootWindow(xDisplay, DefaultScreen(xDisplay)),
                                0, 0,
                                800, 480,
                                1,
                                BlackPixel(xDisplay, DefaultScreen(xDisplay)),
                                WhitePixel(xDisplay, DefaultScreen(xDisplay)));

  eglSurface = eglCreateWindowSurface(eglDisplay, eglConfig,
                                      (EGLNativeWindowType)xWindow, NULL);
  if(eglSurface == EGL_NO_SURFACE){
    printf("eglCreateWindowSurface: Create Window Surface Error\n");
    closeWindow();
    exit(6);
  }

  if(eglMakeCurrent(eglDisplay,
                    eglSurface, eglSurface, eglContext) != EGL_TRUE){
    printf("eglMakeCurrent: Make Current Error\n");
    closeWindow();
    exit(7);
  }

  str = (const char *)glGetString(GL_VERSION);
  if(str != NULL){
    printf("GL_VERSION: %s\n", str);
  }

  str = (const char *)glGetString(GL_VENDOR);
  if(str != NULL){
    printf("GL_VENDOR: %s\n", str);
  }

  str = (const char *)glGetString(GL_RENDERER);
  if(str != NULL){
    printf("GL_RENDERER: %s\n", str);
  }

  str = (const char *)glGetString(GL_SHADING_LANGUAGE_VERSION);
  if(str != NULL){
    printf("GL_SHADING_LANGUAGE_VERSION: %s\n", str);
  }

  str = (const char *)glGetString(GL_EXTENSIONS);
  if(str != NULL){
    printf("GL_EXTENSIONS:\n");
    splitExtensions(str);
  }

  closeWindow();

  exit(0);
}
