/* nub.c version 0.1 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <limits.h>
#include <sys/ioctl.h>
#include <linux/input.h>

#include "nub.h"

void nubProbe(void)
{
  int i;
  int fd;
  int ret;
  int support = 0;
  int dist;
  long absbits[(ABS_MAX+1) / sizeof(long) / 8];
  char nub_path[PATH_MAX];
  struct input_absinfo ainfo;

  for(i = 0 ; i < NUB_MAX ; i++){
    nubInfo[i].fd = -1;
  }

  for(i = 0, nubNums = 0 ; i < INPUT_MAX && nubNums < NUB_MAX ; i++){
    sprintf(nub_path, "/dev/input/event%d", i);
    //printf("Check: [%s]\n", nub_path);

    fd = open(nub_path, O_RDONLY|O_NONBLOCK);
    if(fd < 0){
      continue;
    }

    ret = ioctl(fd, EVIOCGBIT(0, sizeof(support)), &support);
    if(ret == -1){
      close(fd);
      continue;
    }

    if(!(support & (1 << EV_ABS))){
      close(fd);
      continue;
    }

    ret = ioctl(fd, EVIOCGNAME(sizeof(nub_path)), nub_path);
    if(ret == -1 || strncmp(nub_path, "nub", 3) != 0){
      close(fd);
      continue;
    }

    ret = ioctl(fd, EVIOCGBIT(EV_ABS, sizeof(absbits)), absbits);
    if(ret == -1){
      close(fd);
      continue;
    }

    if((absbits[0] & ((1 << ABS_X)|(1 << ABS_Y))) !=
      ((1 << ABS_X)|(1 << ABS_Y))){
      close(fd);
      continue;
    }

    ret = ioctl(fd, EVIOCGABS(ABS_X), &ainfo);
    if(ret == -1){
      close(fd);
      continue;
    }

    dist = ainfo.maximum - ainfo.minimum;
    if(dist != 0){
      nubInfo[nubNums].abs_x_mult = IN_ABS_RANGE * 2 * 65536 / dist;
    }else{
      nubInfo[nubNums].abs_x_mult = 0;
    }
    nubInfo[nubNums].abs_x_adj = -(ainfo.maximum + ainfo.minimum + 1) / 2;

    ret = ioctl(fd, EVIOCGABS(ABS_Y), &ainfo);
    if(ret == -1){
      close(fd);
      continue;
    }

    dist = ainfo.maximum - ainfo.minimum;
    if(dist != 0){
      nubInfo[nubNums].abs_y_mult = IN_ABS_RANGE * 2 * 65536 / dist;
    }else{
      nubInfo[nubNums].abs_y_mult = 0;
    }
    nubInfo[nubNums].abs_y_adj = -(ainfo.maximum + ainfo.minimum + 1) / 2;

    //printf("pandora: found analog #%d \"%s\"\n", nubNums, nub_path);

    nubInfo[nubNums++].fd = fd;
  }

  return;
}

void nubRead(void)
{
  int i;
  int j;
  int fd;
  int ret;
  int num;
  int v;
  struct input_event ie[2];

  for(i = 0 ; i < nubNums ; i++){
    nubInfo[i].flag_x = 0;
    nubInfo[i].flag_y = 0;

    fd = nubInfo[i].fd;
    if(fd < 0){
      continue;
    }

    ret = read(fd, &ie, sizeof(struct input_event) * 2);
    if(ret <= 0){
      continue;
    }

    num = ret / sizeof(struct input_event);
    if(num > 2){
      num = 2;
    }

    for(j = 0 ; j < num ; j++){
      if(ie[j].type != EV_ABS){
        continue;
      }

      if(ie[j].code == ABS_X){
        v = ie[j].value;
        if(nubInfo[i].flag_x == 0){
          nubInfo[i].value_x = v;
          nubInfo[i].flag_x = 1;
        }else{
          nubInfo[i].value_x = v + nubInfo[i].value_x;
        }
      }else
      if(ie[j].code == ABS_Y){
        v = ie[j].value;
        if(nubInfo[i].flag_y == 0){
          nubInfo[i].value_y = v;
          nubInfo[i].flag_y = 1;
        }else{
          nubInfo[i].value_y = v + nubInfo[i].value_y;
        }
      }else{
        continue;
      }
    }
  }

  return;
}

void nubClose(void)
{
  int i;

  for(i = 0 ; i < nubNums ; i++){
    if(nubInfo[i].fd >= 0){
      close(nubInfo[i].fd);
    }
  }

  return;
}
