#!/bin/sh

USE_EXEC=./eglnubsample
USE_OPT=""

if [ ! -x "${USE_EXEC}" ]; then
  echo "${USE_EXEC} not execute"
  exit 1
fi

NUB0_FILE=/proc/pandora/nub0/mode
NUB1_FILE=/proc/pandora/nub1/mode

NUB0_NEW=absolute
NUB1_NEW=absolute

NUB_CHANGE=/usr/pandora/scripts/op_nubchange.sh

if [ -e "${NUB0_FILE}" ]; then
  NUB0_OLD=`cat "${NUB0_FILE}"`
else
  echo "${NUB0_FILE} not found"
  exit 2
fi

if [ -e "${NUB1_FILE}" ]; then
  NUB1_OLD=`cat "${NUB1_FILE}"`
else
  echo "${NUB1_FILE} not found"
  exit 3
fi


if [ X"${NUB0_OLD}" != X"${NUB0_NEW}" -o X"${NUB1_OLD}" != X"${NUB1_NEW}" ]; then
  if [ -x "${NUB_CHANGE}" ]; then
    "${NUB_CHANGE}" "${NUB0_NEW}" "${NUB1_NEW}"
  else
    echo "${NUB0_NEW}" > "${NUB0_FILE}"
    echo "${NUB1_NEW}" > "${NUB1_FILE}"
  fi
fi

"${USE_EXEC}" ${USE_OPT}

if [ X"${NUB0_OLD}" != X"${NUB0_NEW}" -o X"${NUB1_OLD}" != X"${NUB1_NEW}" ]; then
  if [ -x "${NUB_CHANGE}" ]; then
    # /usr/pandora/scripts/op_nubchange.sh mouse mbuttons
    "${NUB_CHANGE}" "${NUB0_OLD}" "${NUB1_OLD}"
  else
    echo "${NUB0_OLD}" > "${NUB0_FILE}"
    echo "${NUB1_OLD}" > "${NUB1_FILE}"
  fi
fi

exit 0
