#!/bin/sh

ANGSTROM_LOCALE_PKG=angstrom-locale-ja-feed-config
LOCALE_BASE_PKG=locale-base-ja-jp

MY_PKG_URI=http://sano-ya.org/pandora/pkg

FONT_PKG=fonts-umeplus
FONT_PKG_FILE=fonts-umeplus_20160402-1_all.ipk

ANTHY_PKG=anthy
ANTHY_PKG_FILE=anthy_9100h-4_omap3-pandora.ipk

UIM_PKG=uim
UIM_PKG_FILE=uim_1.8.6-2_omap3-pandora.ipk

MOUNT_SH=mount.sh
MOUNT_RC=mount.rc

######## Functions
check_pkg () {
  INSTALL_CHECK=`opkg list-installed "${1}"`
  if [ X"${INSTALL_CHECK}" = X"" ]; then
    # no installed
    return 0
  else
    # installed
    return 1
  fi
}

exist_pkg () {
  EXIST_CHECK=`opkg list "${1}"`
  if [ X"${EXIST_CHECK}" = X"" ]; then
    # no exist
    return 0
  else
    # exist
    return 1
  fi
}

get_my_pkg () {
  echo wget -O /tmp/${1} ${MY_PKG_URI}/${1}
       wget -O /tmp/${1} ${MY_PKG_URI}/${1}

  if [ ! -f /tmp/${1} ]; then
    echo "Error: ${1} Package file not download."
    exit 1
  fi

  echo opkg install /tmp/${1}
       opkg install /tmp/${1}

  rm -f /tmp/${1}
}

######## Process Start
IAM=`whoami`
if [ "X${IAM}" != "Xroot" ]; then
  echo "Error: You are not root."
  exit 1
fi

# Network Check
dig sano-ya.org +short > /dev/null 2>&1
if [ $? -ne 0 ]; then
  echo "Error: This PC is not connected to the Internet."
  exit 1
fi

# Update list of available packages
echo opkg update
     opkg update

# Japanese Locale
if check_pkg "${LOCALE_BASE_PKG}" ; then
  if exist_pkg "${LOCALE_BASE_PKG}" ; then
    # no package
    # Install angstrom-locale-ja-feed-config
    if check_pkg "${ANGSTROM_LOCALE_PKG}" ; then
      echo opkg install "${ANGSTROM_LOCALE_PKG}"
           opkg install "${ANGSTROM_LOCALE_PKG}"
    fi

    # Update list of available packages
    echo opkg update
         opkg update
  fi

  # Install locale-base-ja-jp
  echo opkg install "${LOCALE_BASE_PKG}"
       opkg install "${LOCALE_BASE_PKG}"
fi

# for Japanese IM
if check_pkg glibc-gconv-euc-jp ; then
  echo opkg install glibc-gconv-euc-jp
       opkg install glibc-gconv-euc-jp
fi

if check_pkg glibc-charmap-euc-jp ; then
  echo opkg install glibc-charmap-euc-jp
       opkg install glibc-charmap-euc-jp
fi

if check_pkg gtk-immodule-xim ; then
  echo opkg install gtk-immodule-xim
       opkg install gtk-immodule-xim
fi

# Japanese Font
if [ -f pkg/"${FONT_PKG_FILE}" ]; then
  echo opkg install pkg/"${FONT_PKG_FILE}"
       opkg install pkg/"${FONT_PKG_FILE}"
else
  get_my_pkg "${FONT_PKG_FILE}"
fi

# anthy
if [ -f pkg/"${ANTHY_PKG_FILE}" ]; then
  echo opkg install pkg/"${ANTHY_PKG_FILE}"
       opkg install pkg/"${ANTHY_PKG_FILE}"
else
  get_my_pkg "${ANTHY_PKG_FILE}"
fi

# uim
if [ -f pkg/"${UIM_PKG_FILE}" ]; then
  echo opkg install pkg/"${UIM_PKG_FILE}"
       opkg install pkg/"${UIM_PKG_FILE}"
else
  get_my_pkg "${UIM_PKG_FILE}"
fi

# SD Card
if [ -f /etc/udev/scripts/"${MOUNT_SH}" ]; then
  MD5_CHECK=`md5sum /etc/udev/scripts/"${MOUNT_SH}" | awk '{print $1}'`
  if [ -f new/"${MD5_CHECK}"/"${MOUNT_SH}" ]; then
    echo mv /etc/udev/scripts/"${MOUNT_SH}" /home/root/"${MOUNT_SH}".orig
         mv /etc/udev/scripts/"${MOUNT_SH}" /home/root/"${MOUNT_SH}".orig
    echo cp new/"${MD5_CHECK}"/"${MOUNT_SH}" /etc/udev/scripts/
         cp new/"${MD5_CHECK}"/"${MOUNT_SH}" /etc/udev/scripts/
    echo chown root:root /etc/udev/scripts/"${MOUNT_SH}"
         chown root:root /etc/udev/scripts/"${MOUNT_SH}"
    echo chmod 755 /etc/udev/scripts/"${MOUNT_SH}"
         chmod 755 /etc/udev/scripts/"${MOUNT_SH}"
  else
    if [ -f new/sample/"${MOUNT_SH}" ]; then
      echo cp new/sample/"${MOUNT_SH}" /home/root/"${MOUNT_SH}".sample
           cp new/sample/"${MOUNT_SH}" /home/root/"${MOUNT_SH}".sample
    fi
    echo "Please edit /etc/udev/scripts/${MOUNT_SH} by hand."
  fi
fi

if [ -f /etc/xdg/xfce4/"${MOUNT_RC}" ]; then
  MD5_CHECK=`md5sum /etc/xdg/xfce4/"${MOUNT_RC}" | awk '{print $1}'`
  if [ -f new/"${MD5_CHECK}"/"${MOUNT_RC}" ]; then
    echo mv /etc/xdg/xfce4/"${MOUNT_RC}" /home/root/"${MOUNT_RC}".orig
         mv /etc/xdg/xfce4/"${MOUNT_RC}" /home/root/"${MOUNT_RC}".orig
    echo cp new/"${MD5_CHECK}"/"${MOUNT_RC}" /etc/xdg/xfce4/
         cp new/"${MD5_CHECK}"/"${MOUNT_RC}" /etc/xdg/xfce4/
    echo chown root:root /etc/xdg/xfce4/"${MOUNT_RC}"
         chown root:root /etc/xdg/xfce4/"${MOUNT_RC}"
    echo chmod 644 /etc/xdg/xfce4/"${MOUNT_RC}"
         chmod 644 /etc/xdg/xfce4/"${MOUNT_RC}"
  else
    if [ -f new/sample/"${MOUNT_RC}" ]; then
      echo cp new/sample/"${MOUNT_RC}" /home/root/"${MOUNT_RC}".sample
           cp new/sample/"${MOUNT_RC}" /home/root/"${MOUNT_RC}".sample
    fi
    echo "Please edit /etc/xdg/xfce4/${MOUNT_RC} by hand."
  fi
fi

# for user setting
echo ""
echo "Please execute setup.sh script."
echo ""

