#!/bin/sh

UIM_TOOLBAR_GTK=uim-toolbar-gtk

######## Functions
ins_str () {
  grep -s \^"${1}"\$ "${HOME}"/.profile > /dev/null
  if [ $? -eq 1 ]; then
    echo "${1}" >> "${HOME}"/.profile
  fi
}

######## Process Start
IAM=`whoami`
if [ "X${IAM}" = "Xroot" ]; then
  echo "Error: You are root."
  exit 1
fi

CMD=`basename $0`

if [ $# -gt 1 ]; then
  echo "Usage: ${CMD} [systray]"
  exit 1
fi

if [ $# -eq 1 ]; then
  if [ X"${1}" != X"systray" ]; then
    echo "Usage: ${CMD} [systray]"
    exit 1
  fi

  UIM_TOOLBAR_GTK=uim-toolbar-gtk-systray
fi

AS_PATH="${HOME}"/Applications/Settings/autostart

if [ ! -d "${AS_PATH}" ]; then
  mkdir -p "${AS_PATH}"
fi

# for uim-xim auto start
if [ -f "${AS_PATH}"/uim-xim.desktop ]; then
  echo mv "${AS_PATH}"/uim-xim.desktop "${HOME}"/uim-xim.desktop.orig
       mv "${AS_PATH}"/uim-xim.desktop "${HOME}"/uim-xim.desktop.orig
fi

echo "${AS_PATH}/uim-xim.desktop is created."

cat << _EOF_ > "${AS_PATH}"/uim-xim.desktop
[Desktop Entry]
Encoding=UTF-8
Version=0.9.4
Type=Application
Name=uim-xim
Comment=XIM compatibility interface
Exec=/usr/bin/uim-xim
StartupNotify=false
Terminal=false
Hidden=false

_EOF_

# for uim-toolbar-gtk auto start
if [ -f "${AS_PATH}"/uim-toolbar-gtk.desktop ]; then
  echo mv "${AS_PATH}"/uim-toolbar-gtk.desktop "${HOME}"/uim-toolbar-gtk.desktop.orig
       mv "${AS_PATH}"/uim-toolbar-gtk.desktop "${HOME}"/uim-toolbar-gtk.desktop.orig
fi

echo "${AS_PATH}/${UIM_TOOLBAR_GTK}.desktop is created."

cat << _EOF_ > "${AS_PATH}/${UIM_TOOLBAR_GTK}".desktop
[Desktop Entry]
Encoding=UTF-8
Version=0.9.4
Type=Application
Name=${UIM_TOOLBAR_GTK}
Comment=IM toolbar
Exec=/usr/bin/${UIM_TOOLBAR_GTK}
StartupNotify=false
Terminal=false
Hidden=false

_EOF_

# for .profile
echo "${HOME}/.profile is modified."

if [ -f "${HOME}"/.profile ]; then
  ins_str "export LANG=ja_JP.UTF-8"
  ins_str "export LC_ALL=ja_JP.UTF-8"
  ins_str "export XMODIFIERS=@im=uim"
  ins_str "export GTK_IM_MODULE=uim"
else
  cat << _EOF_ >> "${HOME}"/.profile

export LANG=ja_JP.UTF-8
export LC_ALL=ja_JP.UTF-8
export XMODIFIERS=@im=uim
export GTK_IM_MODULE=uim
_EOF_

fi
