/*
Copyright (c) 2011 Sano Yukihiko

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
#ifndef XTGV_H
#define XTGV_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <pwd.h>
#include <ctype.h>
#include <locale.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
//#include <X11/Xlocale.h>

#ifdef USE_XFT
#include <iconv.h>
#include <X11/Xft/Xft.h>
#endif /* USE_XFT */

#ifdef USE_IMLIB
#include <Imlib.h>
#endif /* USE_IMLIB */

#ifdef USE_IMLIB2
#include <Imlib2.h>
#endif /* USE_IMLIB2 */

#define XTGV_TRUE 1
#define XTGV_FALSE 0

#define XTGV_EUC 0
#define XTGV_UTF 1
#define XTGV_LANG_LABEL "LANG"
#define XTGV_LANG_EUC "ja_JP.eucJP"
#define XTGV_LANG_UTF "ja_JP.UTF-8"

#define XTGV_CONF_DIR ".xtgv"
#define XTGV_CONF_CHAR_FILE "char.conf"
#define XTGV_CONF_OPT_FILE "option.conf"

#define XTGV_CONV_NONE 0
#define XTGV_ROTATE_CW 1
#define XTGV_UP_RIGHT 2
#define XTGV_MOVE_SMALL 3

#define XTGV_CHAR_CONFIG_LINE_MAX 512
#define XTGV_CONV_CHAR_ENTRY_MAX 128

#define XTGV_CHAR_LEN 7

#define XTGV_OPTION_CONFIG_LINE_MAX 256
#define XTGV_FONT_NAME_OPTION_MAX 256
#define XTGV_COLOR_NAME_OPTION_MAX 64

#define XTGV_GET_CMAP (DefaultColormap(DpyOfX, DefaultScreen(DpyOfX)))
#define XTGV_GET_VISUAL (DefaultVisual(DpyOfX, DefaultScreen(DpyOfX)))
#define XTGV_GET_SCREEN (DefaultScreen(DpyOfX))

#define XTGV_XCF_FONT_NAME "-*-fixed-medium-r-normal--14-*"

#ifdef USE_XFT
#define XTGV_XFT_FONT_NAME "IPAMincho:pixelsize=14.0"
#endif /* USE_XFT */

#define XTGV_FG_COLOR "black"
#define XTGV_BG_COLOR "white"

#define XTGV_LINES_OF_PAGE 20
#define XTGV_CHARS_OF_LINE 40

#define XTGV_LINES_OF_PAGE_MIN 10
#define XTGV_CHARS_OF_LINE_MIN 10

#define XTGV_DISPLAY_PAGE_OFF 0
#define XTGV_DISPLAY_PAGE_ON 1
#define XTGV_PAGE_MAX 512

#if defined(USE_IMLIB2) || defined(USE_IMLIB)
#define XTGV_IMAGE_MAX 512
#endif /* USE_IMLIB2 || USE_IMLIB */

#if defined(USE_IMLIB2) || defined(USE_IMLIB)

typedef struct XtgvImageDataEntry {
    char *path;
    int x;
    int y;
    int width;
    int height;
    int line;
    Pixmap pixmap;
} XtgvIDE;

typedef struct XtgvImageDataList {
    XtgvIDE *ptr;
    int max;
    int exist;
} XtgvIDL;
#endif /* USE_IMLIB2 || USE_IMLIB */

typedef struct XtgvConvCharEntry {
    int type;
    int num;
    unsigned char str[XTGV_CHAR_LEN];
    int sx;
    int sy;
    XImage *conv_image;
} XtgvCCE;

typedef struct XtgvConvCharList {
    XtgvCCE *ptr;
    int max;
    int exist;
} XtgvCCL;

typedef struct XtgvPageDataEntry {
    unsigned char *start;
    unsigned char *next;
} XtgvPDE;

typedef struct XtgvPageDataList {
    XtgvPDE *page_data;
    int max;
    int exist;
    int complete;
    int current;
} XtgvPDL;

typedef struct XtgvFontDataInfo {
    int box_w;
    int box_h;
    int char_w;
    int char_h;
    int gap_x;
    int gap_y;
    int ruby_box_w;
    int ruby_box_h;
    int ruby_char_w;
    int ruby_char_h;
    int ruby_gap_x;
    int ruby_gap_y;
} XtgvFDI;

void xtgvInit(void);
void xtgvExit(void);
int xtgvCheckOption(int ac, char **av, int flag);
void xtgvReadOptionConfig(char *path);
void xtgvCreateConfig(void);
void xtgvWriteConfig(FILE *fp, unsigned char cl[][XTGV_CHAR_LEN], int type);
int xtgvReadCharConfig(char *path);
void xtgvConvCharListFree(void);
void xtgvPageDataListFree(void);
int xtgvChrNum(unsigned char *str);
int xtgvUTFCount(unsigned char str);
int xtgvEUCCount(unsigned char str);
XtgvCCE *xtgvConvTypeCheck(unsigned char *str);
unsigned char *xtgvHtmlTagDelete(unsigned char *ptr);
int xtgvHtmlTagCheck(unsigned char *ptr, int x, int y, int flag);

int xtgvAnalyzePage(void);
int xtgvGotoPage(int page);
unsigned char *xtgvLayoutPage(unsigned char *start, unsigned char *end, int flag);

int xtgvGetFont(void);
void xtgvEventLoop(void);
void xtgvPageReDraw(void);
int xtgvCreateXImage(XImage **d, XImage **s, unsigned char *ptr, int len);
void xtgvDrawString(unsigned char *ptr, int len, int x, int y, int dst);

#if defined(USE_IMLIB2) || defined(USE_IMLIB)
void xtgvImageDataListFree(void);
#endif /* USE_IMLIB2 || USE_IMLIB */

char *CmdName;

char *FontNameOpt;
char *FgColorNameOpt;
char *BgColorNameOpt;
char *FileNameOpt;
char FontNameOptConf[XTGV_FONT_NAME_OPTION_MAX + 1];
char FgColorNameOptConf[XTGV_COLOR_NAME_OPTION_MAX + 1];
char BgColorNameOptConf[XTGV_COLOR_NAME_OPTION_MAX + 1];
int CurrentPageOpt;
int TagCutFlagOpt;
int LinesOfPageOpt;
int CharsOfLineOpt;
char *CurrentLang;
int CurrentLocale;
XtgvCCL ConvCharList;
int LinesOfPage;
int CharsOfLine;

unsigned char *ReadData;
XtgvPDL PageDataList;

Display *DpyOfX;
Window MainWin;
unsigned int MainWinW;
unsigned int MainWinH;

Pixmap MainPixmap;
unsigned int MainPixmapW;
unsigned int MainPixmapH;
Pixmap ConvPixmap;

unsigned long WinFgPixel;
unsigned long WinBgPixel;

char *FgColorName;
char *BgColorName;
GC FgColorGC;
GC BgColorGC;

char *FontNameXCF;
XFontSet FontSetXCF;

#ifdef USE_XFT
iconv_t IconvCD;

int FontSizeFlag;
int XftUseFlag;
XftFont *FontXft;
XftDraw *DrawXft;
XftDraw *ConvXft;
XftDraw *MainWinXft;
char *FontNameXft;
XftColor ColorXft;
#endif /* USE_XFT */

XtgvFDI FontDataInfo;

#if defined(USE_IMLIB2) || defined(USE_IMLIB)
XtgvIDL ImageDataList;
#endif /* USE_IMLIB2 || USE_IMLIB */

#ifdef USE_IMLIB
ImlibData *ImlibDataExt;
#endif /* USE_IMLIB */

#endif /* XTGV_H */
